﻿;
; (Adobe Edge)アニメーション プラグイン v2.1.3
; keito http://keito-works.com/
;
; ＜導入すると、以下のエフェクト(アニメーション)が扱えます＞
;   1.タイトル エフェクト
;
;
; ＜使い方＞
;   最初に、an_anim.ksを読み込んでください。
;   [call storage="an_anim/an_anim.ks"]
;
;   [an_anim storage="title1.html" op1="タイトル" op2="サブタイトル"]
;
;
; ＜パラメータ一覧＞
;   storage(必須): 表示するエフェクトを指定します。
;   op1   : タイトルを指定します。
;   op2   : サブタイトルを指定します。
;
;   left  : 左端位置を指定します。(ピクセル)
;   top   : 上端位置を指定します。(ピクセル)
;   scale : 倍率を指定します。(例: scale="0.5" scale="1.5" scale="1.0, 0.8" など)
;           ※2個指定した場合は、横と縦の倍率です。
;
;
; ＜使い方例＞
;   640x360に対応させる場合
;   [an_anim storage="title1.html" op1="タイトル" top="-60"]
;   [an_anim storage="title2.html" op1="タイトル" scale="1.0, 0.8" top="-60"]
;   [an_anim storage="title3.html" op1="タイトル" top="-60"]
;   また、an_anim.ksの内容も、以下に変更ください
;   <iframe id="an_anim" width="640" height="360";
;
; ＜注意点＞
;   ティラノスクリプトVer3.00 で動作確認
;
[macro name="an_anim"]
[iscript]
if (mp.op1 != null) {
  mp.op1 = mp.op1.replace(/&blank;/g," ");
}
if (mp.op2 != null) {
  mp.op2 = mp.op2.replace("&blank;"," ");
}
if (mp.top == null || mp.top == "") {
  mp.top = 0;
}
if (mp.left== null || mp.left == "") {
  mp.left = 0;
}
if (mp.scale== null || mp.scale == "") {
  mp.scale = 1;
}
[endscript]

[html]
<div id="an_anim_title" style="position:absolute; visibility:hidden;">[emb exp=mp.op1]</div>
<div id="an_anim_sub" style="position:absolute; visibility:hidden;">[emb exp=mp.op2]</div>
<div id="an_anim_left" style="position:absolute; visibility:hidden;">[emb exp=mp.left]</div>
<div id="an_anim_top" style="position:absolute; visibility:hidden;">[emb exp=mp.top]</div>
<div id="an_anim_scale" style="position:absolute; visibility:hidden;">[emb exp=mp.scale]</div>
<div id="an_anim_scale" style="position:absolute; visibility:hidden;">[emb exp=mp.scale]</div>
<div id="an_anim_wait" style="position:absolute; visibility:hidden;">true</div>
<iframe id="an_anim" width="640" height="480" src="./data/others/an_anim/[emb exp=mp.storage]" scrolling="no" frameborder="0" style="display:none;">
</iframe>
[endhtml]

*an_anim_wait
[wait time=1000]

[iscript]
mp.an_anim_wait = $('#an_anim_wait').text();
[endscript]

[if exp="mp.an_anim_wait=='true'"]
[jump target=*an_anim_wait]
[endif]

[iscript]
$("#an_anim").fadeOut("1000");
[endscript]
[wait time=500]

[cm]
[endmacro]
